close all
clear all
global u_t u_t1 jft
warning off
clc

addpath('C:\Dropbox\bpea\forecasts');


% Import quasi-real time the quaforecast errors
T0=75; %start in 1976m1
T0=364; %start in 2000m1
Tend=446; %end in 2006m12 
%Tend=507; %end in 2011m12
ur=csvread('v1ur.csv',1,1);
ur=ur(T0:Tend,:);

%NOTE: this is in quasi-real time
uf_SSUR2=csvread('ur_ssur2_qrt.csv',1,1);
uf_SSUR2=uf_SSUR2(T0:Tend,:);
uf_SSUR3=csvread('ur_ssur3_qrt.csv',1,1);
uf_SSUR3=uf_SSUR3(T0:Tend,:);

eSSUR2=(uf_SSUR2-ur);
eSSUR3=(uf_SSUR3-ur);


%to mimic less observations as the GB/SPF common sample
% drop=length(eSSUR2):-2:1;
% for j=1:length(drop)
%     eSSUR2(drop(j),:)=[];
%     eSSUR3(drop(j),:)=[];
% end
% drop=length(eSSUR2):-2:1;
% for j=1:length(drop)
%     eSSUR2(drop(j),:)=[];
%    eSSUR3(drop(j),:)=[];
% end

errorsStaff=eSSUR3;
name=['eSSUR3'; ];

errorsStaff=errorsStaff(1:end-0,:);
eSS=eSSUR2(1:end-0,:);

for j=1:round(size(errorsStaff,2)/4)        
    eStaff=errorsStaff(:,1+(j-1)*5:(j)*5);
    
    disp(horzcat('RMSEs Staff forecast:' ));
    disp(horzcat('Model_' ,num2str(name(j,:)) ));
    disp(num2str(100*(sum(eSSUR3.^2,1)./length(eSSUR3)).^.5))
    
    
    disp(' ')
    disp(horzcat('Relative MSE ofSSUR forecast:' ));
    disp(horzcat('Var_' ,num2str(name(j,:)), 'model / Var SS model:' ));
    disp(num2str(sum(eSSUR3.^2,1)./sum(eSS.^2,1)))
    
    % XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
    % DM test and GW test
    % XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
    
    %     for i=1:size(eSS,2)
    %         disp(horzcat(['Diebold-Mariano test at forecast horizon ', num2str(i)], ':   ', num2str(dmtest(eSS(:,i),eSSUR3(:,i),i)) ));
    %     end
    % % XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
    
    dssr=eSSUR3.^2-eSS.^2;
    disp(horzcat([' ']));
    Pval=[];
    for i=1:size(eSS,2)
        [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
        %disp(horzcat(['Giacomini-White test at forecast horizon, p-values  ', num2str(i)], ':   ', num2str(pval) ));
        Pval=[Pval pval];
    end
    disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
    disp(num2str(Pval))
        disp('**********')
    %
    %     % GET THE NBER RECESSION DATES
    %     load C:/Dropbox/SAS-Stata/EUIptqo/nber.mat
    %     nber=nber(13:end); % start in 1971Q1
    %
    %
    %     % Giacomini-Rossi Fluctuation test
    %     dssr=eSSUR3.^2-eSS.^2;
    %     for hz=1:3 % forecast horizon:
    %         DeltaLt=dssr(:,hz);
    %
    %         [F,cvlow,cvup]=Fluctuation(DeltaLt,(1:length(eSS))',20,1,0.05); %20 for window of 5 years? where does forecast horizon enter? (it doesnt, I asked Barbara)
    %         % PLot the G-R Fluctuation test:
    %
    %         F=[NaN(10+hz,1);F;NaN(10+hz,1)];
    %         cvlow=[NaN(10+hz,1);cvlow;NaN(10+hz,1)];
    %         cvup=[NaN(10+hz,1);cvup;NaN(10+hz,1)];
    %
    %         figure(1),subplot(['13',num2str(hz)])
    %         bar(1:length(nber),-1+max(0,5*nber),1,'EdgeColor',[.7,.7,.7],'FaceColor',[.7,.7,.7],'LineStyle','none','Clipping','on'),xlim([1 length(eSSUR3)])
    %         h1=gca;
    %         set(h1,'YAxisLocation','right','Color','white','XTickLabel',[]);
    %         h2=axes('Position',get(h1,'Position'));
    %         plot(F,'black','LineWidth',2)
    %         hold on, plot(cvlow,'--r','LineWidth',2)
    %         hold on, plot(cvup,'--r','LineWidth',2)
    %         if hz==1
    %             title(['Same quarter forecast']), legend('GR test statistic','GR test statistic critical value'), ylabel('Relative performance','Fontsize',10)
    %         end
    %         if hz==2
    %             title(['1-quarter ahead forecast'])
    %         end
    %         if hz==3
    %             title(['2-quarter ahead forecast'])
    %         end
    %         set(h2,'YAxisLocation','left','Color','none')
    %         ylim(h1,[2 3]), set(h1,'Yticklabel',[]), set(h1,'YTick',[],'XTick',[])
    %         %ylim(h2,[-.02 .03]),
    %         set(gca,'Xtick',1:16:length(dssr)), xlim([1 length(nber)])
    %         set(gca','Xticklabel',num2str((1979:4:2012)'),'FontSize',8)
    %         set(h2,'XLim',get(h1,'XLim'),'Layer','top')
    %     end
    
    % figure, plot(eSS(:,hz)-mean(eSS(:,hz)))
    % hold on, plot(eSSUR3(:,hz)-mean(eSSUR3(:,hz)),'--r')
    %
    %
end


% MSE and RMSE of SSUR2
disp(' ')
disp('**********')
disp(horzcat('MSE SSUR2:' ));
disp(num2str(sum(eSS.^2,1)./length(eSSUR3)))
disp(horzcat('RMSE SSUR2:' ));
disp(num2str(100*((sum((eSS).^2,1))./length(eSS)).^.5))


